#include "playercontrol.hpp"

PlayerControl::PlayerControl()
{
  connect(this, SIGNAL(destroyed()), this, SIGNAL(doStop()));
}

void PlayerControl::playPause()
{
  switch(mStatus){
    case PAUSE:
      doStart();
      break;
    case PLAY:
      doPause();
      break;
    case STOP:
      break;
  }
}

void PlayerControl::stop()
{
  doStop();
}

void PlayerControl::started()
{
  mStatus = PLAY;
  sayPlay();
}

void PlayerControl::stopped()
{
  mStatus = STOP;
  sayStop();
}

void PlayerControl::paused()
{
  mStatus = PAUSE;
  sayPause();
}
